class Enemy < GameSprite
  attr_accessor :hit_points

  def initialize(args, info)
    super
    @position = {x: 0, y: 0}
    @size = {w: 32, h: 32}
    @hit_points = 0
    @path = "sprites/circle/black.png"
    @direction = :north

    @can_shoot = false

    @last_shoot_time = args.state.tick_count
    @shoot_delay_ticks = 60 * 5
    @shoot_percentatge = 0.0
    @projectile_ref = nil
  end

  def tick(args)
    raise StandardError, "Enemy.tick: Override me"
  end
  
  def can_shoot
    @can_shoot
  end

  def render
    raise StandardError, "Enemy.render: Override me"
  end

  def collision_rect
    @position.merge(@size)
  end

  def projectile
    @projectile_ref
  end

  ##### For debugging and easy conversion
  def inspect
    serialize.to_s
  end

  def serialize
    to_h
  end

  def to_s
    serialize.to_s
  end

  def flip_horizontally
    @direction == :west
  end

  def flip_vertically
    @direction == :north
  end

  def to_h
    {x: @position.x, y: @position.y, w: @size.w, h: @size.h, source_x: source_x, source_y: source_y, path: @path, primitive_marker: :sprite}
  end
end